import pygame

from OpenGL.GL import *
from OpenGL.GLU import *

from OpenGL.GL.ARB.multitexture import *

max_emboss = .01
multi_texture_supported = False
use_multi_texture = True
max_texel_units = 1

cube = [#front
0.0, 0.0,		-1.0, -1.0, +1.0,
1.0, 0.0,		+1.0, -1.0, +1.0,
1.0, 1.0,		+1.0, +1.0, +1.0,
0.0, 1.0,		-1.0, +1.0, +1.0,
#back
1.0, 0.0,		-1.0, -1.0, -1.0,
1.0, 1.0,		-1.0, +1.0, -1.0,
0.0, 1.0,		+1.0, +1.0, -1.0,
0.0, 0.0,		+1.0, -1.0, -1.0,
#top
0.0, 1.0,		-1.0, +1.0, -1.0,
0.0, 0.0,		-1.0, +1.0, +1.0,
1.0, 0.0,		+1.0, +1.0, +1.0,
1.0, 1.0,		+1.0, +1.0, -1.0,
#bottom
1.0, 1.0,		-1.0, -1.0, -1.0,
0.0, 1.0,		+1.0, -1.0, -1.0,
0.0, 0.0,		+1.0, -1.0, +1.0,
1.0, 0.0,		-1.0, -1.0, +1.0,
#right
1.0, 0.0,		+1.0, -1.0, -1.0,
1.0, 1.0,		+1.0, +1.0, -1.0,
0.0, 1.0,		+1.0, +1.0, +1.0,
0.0, 0.0,		+1.0, -1.0, +1.0,
#left
0.0, 0.0,		-1.0, -1.0, -1.0,
1.0, 0.0,		-1.0, -1.0, +1.0,
1.0, 1.0,		-1.0, +1.0, +1.0,
0.0, 1.0,		-1.0, +1.0, -1.0]
def doFace(offset):
  for i in range(offset,offset+5):
    glTexCoord2f(cube[5*i],cube[5*i+1])
    glVertex3f(cube[5*i+2],cube[5*i+3],cube[5*i+4])
def doCube():
  glNormal3f(0,0,1)
  doFace(0)
  glNormal3f(0,0,-1)
  doFace(5)
  glNormal3f(0,1,0)
  doFace(10)
  glNormal3f(0,-1,0)
  doFace(15)
  glNormal3f(1,0,0)
  doFace(20)
  glNormal3f(-1,0,0)
  doFace(25)

class Screen:
  def __init__(self):
    self.wi = 640
    self.hi = 480
    self.fullscreen = 0
    self.caption = "Nehe lesson 6 - Texture Mapping"
    self.glinited = False
    self.texloaded = False
    
    #textures
    self.textures = []
    self.bumps = []
    self.invbumps = []
    self.glLogo = None
    self.multiLogo = None
    
    #lights
    self.ambient = [.2,.2,.2]
    self.diffuse = [1,1,1]
    self.lposition = [0,0,2]
    self.gray = [.5,.5,.5,1]
    
    #instance variables to be replaced with objects
    self.rot = [0,0,0]
    self.filter = 1
  def initMultiTexture(self):
    if "GL_ARB_multitexture" in glGetString(GL_EXTENSIONS).split(" "):
      global max_texel_units
      max_texel_units = glGetIntegerv(GL_MAX_TEXTURE_UNITS_ARB)
      return True
    global use_multi_texture
    use_multi_texture = False
    return False
  def initLights(self):
    glLightfv(GL_LIGHT1,GL_AMBIENT,self.ambient)
    glLightfv(GL_LIGHT1,GL_DIFFUSE,self.diffuse)
    glLightfv(GL_LIGHT1,GL_POSITION,self.lposition)
    glEnable(GL_LIGHT1)
  def initGL(self):
    self.initMultiTexture()
    if not self.texloaded: self.loadGLTextures()
    glEnable(GL_TEXTURE_2D)
    glShadeModel(GL_SMOOTH)
    glClearColor(0,0,0,0)
    glClearDepth(1.)
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT,GL_NICEST)
    self.initLights()
  def loadGLTextures(self):
    def bind3(image,names,idat=None):
      names.extend(glGenTextures(3))
      if not idat:
        idat = pygame.image.tostring(image,"RGB",True)
      glBindTexture(GL_TEXTURE_2D,names[0])
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST)
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST)
      glTexImage2D(GL_TEXTURE_2D,0,GL_RGB8,image.get_width(),image.get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
      glBindTexture(GL_TEXTURE_2D,names[1])
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
      glTexImage2D(GL_TEXTURE_2D,0,GL_RGB8,image.get_width(),image.get_height(),0,GL_RGB,GL_UNSIGNED_BYTE,idat)
      glBindTexture(GL_TEXTURE_2D,names[2])
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR_MIPMAP_LINEAR)
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
      gluBuild2DMipmaps(GL_TEXTURE_2D,GL_RGB8,image.get_width(),image.get_height(),GL_RGB,GL_UNSIGNED_BYTE,idat)
    bind3(pygame.image.load("Data/Base.bmp"),self.textures)
    
    bump = pygame.image.load("Data/Bump.bmp")
    glPixelTransferf(GL_RED_SCALE,.5)          #half intensity
    glPixelTransferf(GL_GREEN_SCALE,.5)
    glPixelTransferf(GL_BLUE_SCALE,.5)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP)
    bind3(bump,self.bumps)
    
    bdat = pygame.image.tostring(bump,"RGB",True)
    #invert values
    bdat2 = ""
    for c in bdat:
      bdat2 += chr(255-ord(c))
    bind3(bump,self.invbumps,bdat2)
    
    def applyalpha(img1,img2):
      img1 = pygame.image.load(img1)
      img2 = pygame.image.load(img2)
      for x in range(img2.get_width()):
        for y in range(img2.get_height()):
          p = list(img1.get_at([x,y]))
          pa = img2.get_at([x,y])
          p[3] = pa[0]
          img1.set_at([x,y],tuple(p))
      return img1
    ogl = applyalpha("Data/OpenGL.bmp","Data/OpenGL_Alpha.bmp")
    idat = pygame.image.tostring(ogl,"RGBA",True)
    self.glLogo = glGenTextures(1)
    glBindTexture(GL_TEXTURE_2D,self.glLogo)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA8,ogl.get_width(),ogl.get_height(),0,GL_RGBA,GL_UNSIGNED_BYTE,idat)
    
    exten = applyalpha("Data/Multi_On.bmp","Data/Multi_On_Alpha.bmp")
    idat = pygame.image.tostring(exten,"RGBA",True)
    self.multiLogo = glGenTextures(1)
    glBindTexture(GL_TEXTURE_2D,self.multiLogo)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR)
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR)
    glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA8,exten.get_width(),exten.get_height(),0,GL_RGBA,GL_UNSIGNED_BYTE,idat)
  def resize(self):
    wi,hi,fullscreen = self.wi,self.hi,self.fullscreen
    self.screen = pygame.display.set_mode([wi,hi],pygame.OPENGL|pygame.DOUBLEBUF|pygame.FULLSCREEN*fullscreen|pygame.RESIZABLE)
    pygame.display.set_caption(self.caption)
    if hi==0: hi = 1
    glViewport(0,0,wi,hi)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(45.,float(wi)/float(hi),.1,100.)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    if not self.glinited: self.initGL()
  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT)
    glLoadIdentity()
    glTranslatef(0,0,-5)
    glRotatef(self.rot[0],1,0,0)
    glRotatef(self.rot[1],0,1,0)
    glRotatef(self.rot[2],0,0,2)
    #select texture
    glBindTexture(GL_TEXTURE_2D,self.tnames[0])
    glBegin(GL_QUADS)
    #front
    glTexCoord2f(0,0);glVertex3f(-1,-1,1)
    glTexCoord2f(1,0);glVertex3f(1,-1,1)
    glTexCoord2f(1,1);glVertex3f(1,1,1)
    glTexCoord2f(0,1);glVertex3f(-1,1,1)
    #back
    glTexCoord2f(0,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(-1,1,-1)
    glTexCoord2f(0,1);glVertex3f(1,1,-1)
    #left
    glTexCoord2f(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(-1,-1,1)
    glTexCoord2f(1,1);glVertex3f(-1,1,1)
    glTexCoord2f(0,1);glVertex3f(-1,1,-1)
    #right
    glTexCoord2f(0,0);glVertex3f(1,-1,1)
    glTexCoord2f(1,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(1,1,-1)
    glTexCoord2f(0,1);glVertex3f(1,1,1)
    #top
    glTexCoord2f(0,0);glVertex3f(-1,1,1)
    glTexCoord2f(1,0);glVertex3f(1,1,1)
    glTexCoord2f(1,1);glVertex3f(1,1,-1)
    glTexCoord2f(0,1);glVertex3f(-1,1,-1)
    #bottom
    glTexCoord2f(0,0);glVertex3f(-1,-1,-1)
    glTexCoord2f(1,0);glVertex3f(1,-1,-1)
    glTexCoord2f(1,1);glVertex3f(1,-1,1)
    glTexCoord2f(0,1);glVertex3f(-1,-1,1)
    glEnd()
    self.rot[0]+=.1
    self.rot[1]+=.05
    self.rot[2]+=.005

screen = Screen()
screen.resize()

running = 1
while running:
  screen.draw()
  pygame.display.flip()
  for e in pygame.event.get():
    if e.type==pygame.VIDEORESIZE:
      screen.wi,screen.hi = e.w,e.h
      screen.resize()
    if e.type==pygame.KEYDOWN:
      if e.key==pygame.K_ESCAPE:
        running = 0
      if e.key==pygame.K_RETURN:
        screen.wi,screen.hi,screen.fullscreen=40,40,0
        screen.resize()
        
